local t = Def.ActorFrame{
	Def.StepsDisplayList {
		Name="StepsDisplayListRow",

		CursorP1 = Def.ActorFrame {
			InitCommand=cmd(x,-120;player,PLAYER_1),
			PlayerJoinedMessageCommand=function(self, params)
				if params.Player == PLAYER_1 then
					self:visible(true)
				end
			end,
			PlayerUnjoinedMessageCommand=function(self, params)
				if params.Player == PLAYER_1 then
					self:visible(false)
				end
			end,
			Def.Quad {
				InitCommand=function(self)
					self:diffuse(PlayerColor(PLAYER_1)):zoomto(20,18):horizalign(right):diffuserightedge(Color.Black)
				end
			},
			Def.BitmapText {
				Font = "Common Small",
				Text=">",
				InitCommand=cmd(x,-10;diffuse,Color.White;strokecolor,PlayerColor(PLAYER_1);zoom,0.7;horizalign,right)
			},
		},
		CursorP2 = Def.ActorFrame {
			InitCommand=cmd(x,120;player,PLAYER_2),
			PlayerJoinedMessageCommand=function(self, params)
				if params.Player == PLAYER_2 then
					self:visible(true)
				end
			end,
			PlayerUnjoinedMessageCommand=function(self, params)
				if params.Player == PLAYER_2 then
					self:visible(false)
				end
			end,
			Def.Quad {
				InitCommand=function(self)
					self:diffuse(PlayerColor(PLAYER_2)):zoomto(20,18):horizalign(left):diffuseleftedge(Color.Black)
				end
			},
			Def.BitmapText {
				Font = "Common Small",
				Text="<",
				InitCommand=cmd(x,10;diffuse,Color.White;strokecolor,PlayerColor(PLAYER_2);zoom,0.7;horizalign,left)
			},
		},
		CursorP1Frame = Def.Actor{
			ChangeCommand=cmd(stoptweening;decelerate,0.1)
		},
		CursorP2Frame = Def.Actor{
			ChangeCommand=cmd(stoptweening;decelerate,0.1)
		}
	},
	
	Def.Quad{
		OnCommand=function(self)
			self:diffuse(LocalBlueColor(0.75)):zoomto(280,(_screen.cy/2)-16):y((_screen.cy/4)-20)
		end,
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set"),
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"),
		SetCommand=function(self)
			local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
			local newY = target and 1 or 0
			if newY ~= self:getaux() then
				self:stoptweening():linear(0.2):croptop(newY):aux(newY)
			end
		end
	}
}



return t